// service-worker.js

var CACHE_NAME = 'my-cache';
var urlsToCache = [
    '/',
    '/css/style.css',
    // ҪԴ URL
];

self.addEventListener('install', function (event) {
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(function (cache) {
                console.log('Opened cache');
                return cache.addAll(urlsToCache);
            })
    );
});

self.addEventListener('fetch', function (event) {
    event.respondWith(
        caches.match(event.request)
            .then(function (response) {
                // ԴѾڻУֱӷ
                if (response) {
                    return response;
                }

                // 򣬴ȡԴ
                return fetch(event.request).then(
                   return fetch(event.request).then(
                    function (response) {
                        // ǵõЧӦ
                        if (!response || response.status !== 200) {
                            return response;
                        }

                        // Ӧһζȡ
                        var responseToCache = response.clone();

                        caches.open(CACHE_NAME)
                            .then(function (cache) {
                                cache.put(event.request, responseToCache);
                            });

                        return response;
                    }
                );
            })
    );
});

